"""Uses CoverageMapper to map data to CMS-Wave grid."""

__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging

# 2. Third party modules
from PySide2.QtCore import QThread, Signal

# 3. Aquaveo modules

# 4. Local modules
from xms.cmswave.mapping.coverage_mapper import CoverageMapper


class CoverageMapperRunner(QThread):
    """Class for mapping structures coverage to a grid for CMS-Wave."""
    processing_finished = Signal()

    def __init__(self, query, main_file):
        """Constructor."""
        super().__init__()
        self._query = query
        self._logger = logging.getLogger('xms.cmswave')
        self.mapped_component = None
        self.main_file = main_file

    def run(self):
        """Creates the snap preview of coverages onto the mesh."""
        try:
            worker = CoverageMapper(self._query, self.main_file)
            worker.do_map()
            self.mapped_component = worker.mapped_comps
        except:  # noqa
            self._logger.exception('Error generating snap.')
        finally:
            self.processing_finished.emit()
