"""Entry point for writing CMS-Wave spatial dataset files."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 4. Local modules
from xms.cmswave.file_io.dataset_writer import export_all_datasets
from xms.cmswave.xml_entry_points.parallel_process import read_dataset_script_args


def main():
    """Entry point wrapper."""
    try:
        xms_data = read_dataset_script_args()
        export_all_datasets(xms_data)
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":
    main()
