from .. import _xmsconstraint


class ContourSorter:
    """Sorts 2D contours."""
    def __init__(self):
        self._instance = _xmsconstraint.contour.ContourSorter()

    def sort_segments(self, segments, xytol, ztol = None):
        """
        Sorts contour segments and returns the contour lines.

        Args:
            segments: The input contour segments.
            xytol: The XY tolerance.
            ztol: The Z tolerance.

        Return:
            status: The status of SortSegments call.
            lines: The output sorted contour lines.
        """
        ret_status, contours = self._instance.SortSegments(segments, xytol, 0.0, False)
        ret_contours = []
        for contour in contours:
            ret_contours.append(contour.tolist())
        return ret_status, ret_contours
