from . import _xmsconstraint


def write_to_string_with_uuid(co_grid):
    """
    Write a grid to a string with the UUID at the beginning.
    Args:
        file_path: Path to the file to read from.
        co_grid: The constrained grid.
    Returns:
        The grid file as a string.
    """
    file_string = _xmsconstraint.constraint.coWriteToStringWithUuid(co_grid._instance)
    return file_string


def write_to_file_with_uuid(file_path, co_grid):
    """
    Write a grid to file with the UUID at the beginning.
    Args:
        file_path: Path to the file to read from.
        co_grid: The constrained grid.
    """
    _xmsconstraint.constraint.coWriteToFileWithUuid(file_path, co_grid._instance)
