from abc import ABC

from .rectilinear_geometry import RectilinearGeometry
from .grid import Grid
from .quadtree import QuadGridCellsGetters


class QuadtreeGrid(Grid, RectilinearGeometry, ABC):
    """Quad tree constrained UGrid."""

    def __init__(self, instance):
        """Only called by subclasses.
        Args:
            instance: The C++ wrapped instance.
        """
        Grid.__init__(self, instance)
        RectilinearGeometry.__init__(self, instance)

    @property
    def quad_grid_cells(self):
        """The QuadGridCells which give the cell refinement and cell
        indices."""
        return QuadGridCellsGetters(self._instance.GetQuadGridCells())
