# 1. Standard python modules
from typing import List

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from . import Grid, _xmsconstraint
from .grid_reader import _grid_from_cpp_co_grid


def extrude_grid(grid: Grid, thicknesses: List[float]) -> Grid:
    """
    Extrude a 2D grid downward to create a 3D grid.
    Args:
        grid(Grid): The 2D grid.
        thicknesses(List[float]): Thickness of each layer top to bottom.
    Returns:
        (Grid): The new 3D grid.
    """
    co_grid_types = _xmsconstraint.ugrid.ugExtrudeCoGrid(grid._instance, thicknesses)
    return _grid_from_cpp_co_grid(co_grid_types)
