"""Python wrapping for xms._data_objects.parameters.RectilinearCell."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.data_objects._data_objects.parameters import RectilinearCell as CRectilinearCell
from xms.data_objects.parameters.spatial.Point import Point as PyPoint


class RectilinearCell:
    """The pure Python wrapper for C++ exposed xms._data_objects.parameters.RectilinearCell objects."""
    def __init__(self, instance=None):
        """Construct the wrapper.

        Args:
            instance (xms._data_objects.parameters.RectilinearCell): The C++ object to wrap
        """
        if instance:
            self._instance = instance
        else:
            self._instance = CRectilinearCell()

    @property
    def id(self):
        """Returns the cell's id."""
        return self._instance.GetId()

    @id.setter
    def id(self, cell_id):
        """Sets the cell's id.

        Args:
            cell_id (int): Id to assign the cell
        """
        self._instance.SetId(cell_id)

    @property
    def i(self):
        """Returns the cell's i-offset."""
        return self._instance.GetI()

    @property
    def j(self):
        """Returns the cell's j-offset."""
        return self._instance.GetI()

    @property
    def centroid(self):
        """Returns the cell's centroid as a xms.data_objects.parameters.Point."""
        centroid = self._instance.GetLocation()
        if centroid is not None:
            # Create a pure Python wrapper for the centroid if there is one defined.
            centroid = PyPoint(instance=centroid)
        return centroid

    @centroid.setter
    def centroid(self, point):
        """Sets the cell's centroid.

        Args:
            point (xms.data_objects.parameters.Point): The location of the centroid
        """
        self._instance.SetLocation(point._instance)

    def set_ij(self, i, j):
        """Set the cell's offset in the i and j directions.

        Args:
            i (int): The cell's i-offset
            j (int): The cell's j-offset
        """
        self._instance.SetIJ(i, j)
