"""SMS entry point for the simulation export script."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 4. Local modules
from xms.funwave.feedback.simulation_export_runner import export_simulation_with_feedback


def main():
    """Entry point wrapper."""
    try:
        export_simulation_with_feedback()
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":
    main()
