"""Exports GenCade simulation."""

__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging
import os

# 2. Third party modules
from PySide2.QtCore import QThread, Signal

# 3. Aquaveo modules

# 4. Local modules
from xms.gencade.file_io.gen_writer import GenFileExporter


class ExportSimulationRunner(QThread):
    """Class for exporting GenCade."""
    processing_finished = Signal()

    def __init__(self, out_dir):
        """Constructor.

        Args:
            out_dir (str): output directory
        """
        super().__init__()
        self.out_dir = os.path.normpath(out_dir)
        self.query = None
        self.sim_query_helper = None
        self.coverage_mapper = None
        self._exporter = None
        self.project_name = None
        self.sim_component = None
        self.wse_data = None
        self.ceiling_file = None
        self.vwse_dsets = None
        self._logger = logging.getLogger('xms.gencade')
        self.files_exported = []

    def run(self):
        """Exports GenCade sim files."""
        try:
            self._logger.info('Do export...')
            gen_writer = GenFileExporter()
            gen_writer.write()

        except Exception as error:
            err_str = str(error)
            if err_str:
                self._logger.exception(f'Error exporting simulation: {err_str}')
                raise error
        finally:
            self.processing_finished.emit()
