"""This is a utility for converting text in edit fields to prevent empty strings."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class TextConverter:
    """A class for converting string between dialog display and stored values."""
    _empty_filler = '(none selected)'

    @staticmethod
    def get_text_for_field(text):
        """This gets text for an edit field.

        Args:
            text (:obj:`str`): The text to set the edit field to.

        Returns:
            (:obj:`str`): A string that is either the original text or an empty string.
        """
        if text == TextConverter._empty_filler:
            text = ''
        return text

    @staticmethod
    def get_text_from_field(field_text):
        """This gets text for storage from an edit field.

        Args:
            field_text (:obj:`str`): The text from the edit field.

        Returns:
            (:obj:`str`): A string that is either the original text or filler text if empty.
        """
        if field_text == '':
            field_text = TextConverter._empty_filler
        return field_text
