"""Python enumeration for XMS target display types."""

# 1. Standard Python modules
from enum import IntEnum

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


# in order XMS is expecting
class TargetType(IntEnum):
    """An enumeration of possible target types matching TargetDisplayTypes in XMS."""

    point = 0
    arc = 1
    polygon = 2
    ugrid_point = 3
    ugrid_cell_center = 4
    ugrid_pointstring = 5
    ugrid_cellstring = 6
    ugrid_cellface_fill = 7
    ugrid_cellface_fill_interior = 8
    # This is feature arc groups that were added later for GMS. Needs to be here so it is 2 less than its corresponding
    # value in the XMS eEntityType enum.
    arc_group = 9
