"""Implementation of QListWidget for use in XMS Python packages."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import QSize
from PySide2.QtWidgets import QListWidget

# 3. Aquaveo modules

# 4. Local modules


class QxListWidget(QListWidget):
    """Class derived from QListWidget to override sizeHint."""
    def sizeHint(self):  # noqa: N802
        """Returns the size hint. Overridden to size to contents.

        From https://stackoverflow.com/questions/6337589/qlistwidget-adjust-size-to-content

        Returns:
            See description.
        """
        s = QSize()
        s.setHeight(super().sizeHint().height())
        s.setWidth(self.sizeHintForColumn(0) + 20)  # 20 is a buffer. Looks better
        return s
