"""Formats text output."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class TextFormatter:
    """Text Formatter for points and other data."""

    def __init__(self):
        """Constructor."""
        pass

    @staticmethod
    def create_text_in_columns(columns, width, points):
        """Creates formatted list of text in columns.

        Args:
            columns (int): Number of columns
            width (int): Number of rows
            points (:obj:`list` of :obj:`list` of float): Point locations to print

        Returns:
            (:obj:`list` of str): Lines of text.
        """
        cleanedpoints = []
        # I  check the position of the point, and the numbers on the left to be sure that it fits.
        for point in points:
            cleanedpoint = []
            for coord in point:
                coordastext = str(coord)
                length = len(coordastext)
                pointposition = coordastext.find(".")
                if pointposition == -1:     # There is no point
                    intpart = length
                else:
                    intpart = pointposition
                if intpart > width:     # It doesn't fit in the column
                    print("Error: coordinate " + coordastext + " doesn't fit in the column")
                elif length > width:        # It requires some trimming. Loss of precission.
                    # print("Warning: coordinate " + coordastext + " will be trimmed to " + coordastext[:width])
                    coordastext = coordastext[:width]
                else:       # It requires some padding
                    for _ in range(0, width - length):
                        coordastext = " " + coordastext
                cleanedpoint.append(coordastext)
            cleanedpoints.append(cleanedpoint)
        qty = len(cleanedpoints)
        # Create groups of #columns points
        groups = []
        j = 0
        for _ in range(0, int(qty / columns)):
            group = []
            for _ in range(0, columns):
                group.append(cleanedpoints[j])
                j = j + 1
            groups.append(group)
        if j < qty:
            group = cleanedpoints[j:]
            groups.append(group)
        # Create the lines of text
        lines = []
        for group in groups:
            line = ""
            for point in group:
                line = line + point[0] + point[1]
            lines.append(line)
        return lines

    @staticmethod
    def create_text_in_columns_for_values(columns, width, data):
        """Creates a list of text for the data given.

        Args:
            columns (int): Number of columns
            width (int): Number of rows
            data (:obj:`list` of int or float or str): Data to format into text.

        Returns:
            (:obj:`list` of str): Formatted list of text.
        """
        cleaneddata = []
        # I  check the position of the point, and the numbers on the left to be sure that it fits.
        for value in data:
            valueastext = str(value)
            length = len(valueastext)
            pointposition = valueastext.find(".")
            if pointposition == -1:     # There is no point
                intpart = length
            else:
                intpart = pointposition
            if intpart > width:     # It doesn't fit in the column
                print("Error: value " + valueastext + " doesn't fit in the column")
            elif length > width:        # It requires some trimming. Loss of precission.
                print("Warning: value " + valueastext + " will be trimmed to " + valueastext[-width:])
                valueastext = valueastext[-width:]
            else:       # It requires some padding
                for _ in range(0, width - length):
                    valueastext = " " + valueastext
            cleaneddata.append(valueastext)
        qty = len(cleaneddata)
        # Create groups of #columns points
        groups = []
        j = 0
        for _ in range(0, int(qty / columns)):
            group = []
            for __ in range(0, columns):
                group.append(cleaneddata[j])
                j = j + 1
            groups.append(group)
        if j < qty:
            group = cleaneddata[j:]
            groups.append(group)
        # Create the lines of text
        lines = []
        for group in groups:
            line = ""
            for value in group:
                line = line + value
            lines.append(line)
        return lines
