"""HgsCoverageComponentBase class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.components.coverage_component import CoverageComponent
from xms.gmi.data.generic_model import Group

# 4. Local modules


class HgsCoverageComponentBase(CoverageComponent):
    """A base class for HGS coverage components."""
    def __init__(self, main_file: str) -> None:
        """Initializes the class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)
        self._inactive_group_name = ''  # Overriden from base class cause our group names are strings
        # We shouldn't actually need to do anything with _multiple_active_group_name since we use exclusive groups,
        # but in case that changes in the future...
        self._multiple_active_group_name = '$MGROUP$'  # Overriden from base class cause our group names are strings
        message = (
            'This HydroGeoSphere interface is in "beta". Feedback is appreciated. Please report any bugs to'
            ' <a href=\'mailto:support@aquaveo.com?cc=support@aquanty.com\'>support@aquaveo.com</a>.'
        )
        style_sheet = 'QLabel { background-color : rgb(200, 200, 150); color : rgb(0, 0, 0); }'
        self._banner = (message, style_sheet)

    def make_map_att(self, feature, att_type: str, group: Group):
        """Returns a MapAtt.

        Args:
            feature: A point, arc, or polygon.
            att_type (str): Attribute type (e.g. 'Flux nodal')
            group (Group): The BC as a generic model group.

        Returns:
            (Type[MapAtt]): The MapAtt object.
        """
        raise NotImplementedError('make_map_att')  # pragma no cover - shouldn't ever get here
