"""Domains class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class Domains:
    """Just an enumeration of the domains and their string representation so that we are consistent everywhere.

    The strings come from the reference manual section 2.8.1.
    """
    PM = 'Porous media'  #: Porous media domain
    OLF = 'Surface flow'  #: Surface flow domain
    ET = 'ET'  #: ET domain


def domain_abbreviation(domain: str) -> str:
    """Returns the short abbreviation associated with the domain.

    Args:
        domain (str): Domains string.

    Returns:
        (str): See description.
    """
    if domain == Domains.PM:
        return 'pm'
    elif domain == Domains.OLF:
        return 'olf'
    elif domain == Domains.ET:
        return 'et'
    else:
        raise RuntimeError(f'Unsupported domain: "{domain}"')


def domain_type(domain: str) -> str:
    """Returns the domain type (see "Use domain type" command) given the domain string.

    Args:
        domain (str):

    Returns:
        (str): See description.
    """
    if domain == Domains.PM:
        return 'porous media'
    elif domain == Domains.OLF:
        return 'surface'
    elif domain == Domains.ET:
        return 'et'
    else:
        raise RuntimeError(f'Unsupported domain: "{domain}"')
