"""Module for MappedMaterialComponent."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['MappedMaterialComponent']

# 1. Standard Python modules
from functools import cached_property

# 2. Third party modules

# 3. Aquaveo modules
from xms.components.bases.component_with_menus_base import ComponentWithMenusBase

# 4. Local modules
from xms.hydroas.data.mapped_material_data import MappedMaterialData


class MappedMaterialComponent(ComponentWithMenusBase):
    """Component for mapped materials."""
    @cached_property
    def data(self):
        """The component's data manager."""
        return MappedMaterialData(self.main_file)
