"""Data module."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel

# 4. Local modules


def get_version(model: GenericModel, model_values: str) -> str:
    """
    Get the version string for a HydroAS model.

    Args:
        model: The model to use for extracting the version strings.
        model_values: Values to restore into model.model_parameters.
    """
    model = model.copy()
    model.model_parameters.restore_values(model_values)
    version = model.model_parameters.group('model').parameter('model_name').value.lower()
    prefixes = ['hydro', '-', '_', 'as', '-2d']
    for prefix in prefixes:
        version = version.removeprefix(prefix)
    version = version.strip(' )(v')
    return version
