"""MaterialData class."""

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel

# 4. Local modules
from xms.hydroas.data.coverage_data import CoverageData


class MaterialData(CoverageData):
    """
    Manages data file for a material component.

    See `CoverageData` for the majority of `MaterialData` functionality.

    `MaterialData` derives from `CoverageData` to add material value storage and retrieval. It does not define its own
     datasets; it uses the polygon one instead.
    """
    @property
    def material_values(self) -> str:
        """
        The shared values for material parameters.

        This does not include group activity.
        """
        if 'MATERIAL_VALUES' in self.info.attrs:
            return self.info.attrs['MATERIAL_VALUES']
        # Let GenericModel define the defaults in case it wants to change them.
        return GenericModel().material_parameters.extract_values()

    @material_values.setter
    def material_values(self, value: str):
        """
        The shared values for material parameters.

        This does not include group activity.
        """
        self.info.attrs['MATERIAL_VALUES'] = value
