"""DisComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.components.dis_component_base import DisComponentBase
from xms.mf6.gui.dis_dialog import DisDialog


class DisComponent(DisComponentBase):
    """A Dynamic Model Interface (DMI) component for DIS package data."""
    def __init__(self, main_file):
        """Initializes the class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)
        self.ftype = 'DIS6'  # package ftype
        self.dialog = DisDialog
