"""GwtGwtComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.components.package_component_base import PackageComponentBase
from xms.mf6.gui.exchanges.gwt_gwt_dialog import GwtGwtDialog


class GwtGwtComponent(PackageComponentBase):
    """A Dynamic Model Interface (DMI) component for a GWF (Groundwater Flow) model."""
    def __init__(self, main_file):
        """Initializes the class.

        Args:
            main_file (str): File path to main file.
        """
        super().__init__(main_file.strip('\'"'))
        self.ftype = 'GWT6-GWT6'  # package ftype
        self.dialog = GwtGwtDialog
