"""DisReaderBase class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_reader import PackageReader


class DisReaderBase(PackageReader):
    """Base class for reading a DIS, DISV, or DISU package file."""
    def __init__(self, ftype):
        """Initializes the class."""
        super().__init__(ftype=ftype)
        self._data = None
        self._block_methods = {'VERTICES': '_handle_list_block', 'CELL2D': '_handle_list_block'}

    def _on_begin_block(self, block_name: str) -> None:
        """Called when a BEGIN [block] line is found.

        Args:
            block_name (str): Name of the current block.
        """
        if block_name == 'GRIDDATA':
            self._data.block(block_name).delete_arrays()
