"""DisvWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import io_util
from xms.mf6.file_io.package_writer_base import PackageWriterBase


class DisvWriter(PackageWriterBase):
    """Writes the package to disk."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._fp = None

    def _write_dimensions(self):
        """Writes the DIMENSIONS block."""
        self._fp.write('\n')
        self._fp.write('BEGIN DIMENSIONS\n')
        self._fp.write(f'{io_util.mftab}NLAY {self._data.grid_info().nlay}\n')
        self._fp.write(f'{io_util.mftab}NCPL {self._data.grid_info().ncpl}\n')
        self._fp.write(f'{io_util.mftab}NVERT {self._data.grid_info().nvert}\n')
        self._fp.write('END DIMENSIONS\n')

    def _write_vertices(self):
        """Writes the VERTICES block."""
        self._write_list_block('VERTICES', self._fp)

    def _write_cell2d(self):
        """Writes the CELL2D block."""
        self._write_list_block('CELL2D', self._fp)

    def _write_package(self, data):
        """Writes the package data to disk.

        Args:
            data (StoData): The package data.
        """
        self._data = data
        with open(data.filename, 'w') as self._fp:
            self._write_comments(self._fp)
            self._write_options(self._fp)
            self._write_dimensions()
            self._write_griddata(self._fp)
            self._write_vertices()
            self._write_cell2d()
