"""GriddataPackageWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_writer_base import PackageWriterBase


class GriddataPackageWriter(PackageWriterBase):
    """Writes the package to disk.

    This applies to: IC, NPF, DSP, IST, MDT, MST.
    """
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._fp = None

    def _write_package(self, data):
        """Writes the package data to disk.

        Args:
            data: The package data.
        """
        self._data = data
        with open(data.filename, 'w') as self._fp:
            self._write_comments(self._fp)
            self._write_options(self._fp)
            self._write_griddata(self._fp)
