"""GncReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_reader import PackageReader


class GncReader(PackageReader):
    """Reads a GNC package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__(ftype='GNC6')
        self._block_methods = {'GNCDATA': '_handle_list_block'}

    def _read_dimensions(self, line):
        """Reads the dimensions block.

        Args:
            line (str): line from file
        """
        words = line.split()
        if not words:
            self.invalid_line_in_file(line)
            return

        if words[0].upper() == 'NUMALPHAJ' and len(words) > 1:
            self._data.numalphaj = int(words[1])
