"""MvrWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import io_util
from xms.mf6.file_io.list_package_writer import ListPackageWriter


class MvrWriter(ListPackageWriter):
    """Writes a list package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._data = None  # ListPackageData

    def _write_dimensions(self, fp):
        """Writes the dimensions block.

        Args:
            fp (_io.TextIOWrapper): The file.
        """
        # self._data.period_files gets filled in at first call to self._write_stress_periods(None) below
        self._data.maxbound = io_util.count_max_line(list(self._data.period_files.values()))
        if 'PACKAGES' in self._data.list_blocks:
            self._data.maxpackages = io_util.count_max_line([self._data.list_blocks['PACKAGES']])

        fp.write('\n')
        fp.write('BEGIN DIMENSIONS\n')
        fp.write(f'{io_util.mftab}MAXMVR {self._data.maxbound}\n')
        fp.write(f'{io_util.mftab}MAXPACKAGES {self._data.maxpackages}\n')
        fp.write('END DIMENSIONS\n')

    def _write_package(self, data):
        """Writes the package file.

        Saves stress period data in external files using the OPEN/CLOSE option.
        """
        self._data = data
        # Do this first to populate self._data.period_files so _write_dimensions works
        self._write_stress_periods(None)

        with open(self._data.filename, 'w') as fp:
            self._write_comments(fp)
            self._write_options(fp)
            self._write_dimensions(fp)
            self._write_list_block('PACKAGES', fp)
            self._write_stress_periods(fp)
