"""TimeSeriesWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import io_util
from xms.mf6.file_io.list_package_writer import ListPackageWriter


class TabWriter(ListPackageWriter):
    """Writes the file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._data = None

    def _write_dimensions(self, fp):
        """Writes the dimensions block.

        Args:
            fp (_io.TextIOWrapper): The file.
        """
        nrow = io_util.count_max_line([self._data.list_blocks['TABLE']])
        fp.write('\n')
        fp.write('BEGIN DIMENSIONS\n')
        fp.write(f'{io_util.mftab}NROW {nrow}\n')
        fp.write(f'{io_util.mftab}NCOL {self._data.ncol}\n')
        fp.write('END DIMENSIONS\n')

    def write(self, data):
        """Writes the time series.

        Args:
            data (TabData): Table data
        """
        self._data = data
        with open(self._data.filename, 'w') as fp:
            self._write_comments(fp)
            self._write_dimensions(fp)
            self._write_list_block('TABLE', fp)
