"""TimeArraySeriesWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.time_array_series_data import TimeArraySeriesData


class TimeArraySeriesWriter:
    """Writes the file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._data = None

    def write(self, data: TimeArraySeriesData):
        """Writes the time array series.

        Args:
            data: ?
        """
        filepath = Path(data.filename)
        if not filepath.exists():
            filepath.touch()
