"""DialogInput class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import ActionRequest

# 4. Local modules


class DialogInput:
    """Data for dialogs."""
    def __init__(
        self,
        data=None,
        locked=False,
        selected_cells=None,
        filter_on_selected_cells=True,
        sto_data_list=None,
        data_list=None,
        locked_list=None,
        ugrid_uuid='',
        query=None,
        help_id='',
        mfsim=None
    ):
        """Initializes the class.

        Args:
            data: The data class.
            locked (bool): True if component is locked.
            selected_cells (list of int): List of selected cells.
            filter_on_selected_cells (bool): True to filter on selected cells.
            sto_data_list: ?
            data_list: ?
            locked_list: List of locked dialogs.
            ugrid_uuid (str): UUID of the UGrid.
            query: The query.
            help_id (str): Identifier used to find the help url.
            mfsim (MfsimData): The simulation object.
        """
        if selected_cells is None:
            selected_cells = []
        if sto_data_list is None:
            sto_data_list = []
        if data_list is None:
            data_list = []
        if locked_list is None:
            locked_list = []
        self.data = data  # The package data class
        self.locked = locked  # True if the component is locked
        self.selected_cells = selected_cells  # List of selected cell indexes
        self.filter_on_selected_cells = filter_on_selected_cells  # True to filter on selected cells
        self.sto_data_list = sto_data_list  # List of StoData for use with TDIS package
        self.data_list = data_list  # List of data classes. Used with Sources / Sinks dialog
        self.locked_list = locked_list  # List of locked state.  Used with Sources / Sinks dialog
        self.ugrid_uuid = ugrid_uuid  # UUID of the UGrid
        self.query = query  # Query for XMS communication
        self.help_id = help_id
        self.mfsim = mfsim
        self.restore_on_cancel = False
        self.actions: list[ActionRequest] = []  # Actions needed when leaving the dialog
