"""GwfGwfDialog class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.gui import list_dialog
from xms.mf6.gui.exchanges.gwx_gwx_dialog_base import GwxGwxDialogBase


class GwfGwfDialog(GwxGwxDialogBase):
    """A dialog used for the GWF-GWF exchange."""
    def __init__(self, dlg_input, parent=None):
        """Initializes the class, sets up the ui, and loads the package.

        Args:
            dlg_input (DialogInput): Information needed by the dialog.
            parent (Something derived from QWidget): The parent window.
        """
        super().__init__(dlg_input, parent)

    def on_btn_gnc6_filein(self):
        """Called when a FILEIN button is clicked."""
        list_dialog.run_list_dialog_for_filein('GNC6', self, self.options_gui.options_block)

    def on_btn_mvr6_filein(self):
        """Called when a FILEIN button is clicked."""
        list_dialog.run_list_dialog_for_filein('MVR6', self, self.options_gui.options_block)
