"""QxSpinBoxStyle class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import (QProxyStyle, QStyle)

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.misc import util


class QxSpinBoxStyle(QProxyStyle):
    """To fix period spin box from jumping twice.

    See https://stackoverflow.com/questions/40746350/why-qspinbox-jumps-twice-the-step-value.
    The original used 10**10 but that lead to OverflowError.
    """
    def styleHint(self, hint, option=None, widget=None, returnData=None):  # noqa N802, N803
        """Returns an int representing the specified style hint for given widget described by the provided style option.

        Args:
            hint: The hint.
            option: The option.
            widget: The widget.
            returnData: used when the querying widget needs more detailed data than the int that styleHint() returns.

        Returns:
            See description.
        """
        if hint == QStyle.SH_SpinBox_KeyPressAutoRepeatRate:
            # return 10**10
            return util.max_int32
        elif hint == QStyle.SH_SpinBox_ClickAutoRepeatRate:
            # return 10**10
            return util.max_int32
        elif hint == QStyle.SH_SpinBox_ClickAutoRepeatThreshold:
            # You can use only this condition to avoid the auto-repeat,
            # but better safe than sorry ;-)
            # return 10**10
            return util.max_int32
        else:
            return super().styleHint(hint, option, widget, returnData)
