"""CellAdderPolys class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from typing_extensions import override

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.mapping.cell_adder import CellAdder
from xms.mf6.misc.util import XM_NODATA


class CellAdderPolys(CellAdder):
    """Adds a cell BC."""
    def __init__(self, builder, cell_idx, record, period_rows: list, ix_area: float):
        """Initializes the class.

        Args:
            builder: The package builder.
            cell_idx: Cell index.
            record: Shapefile record for the current polygon.
            period_rows: List of rows for a stress period.
            ix_area: Intersected area of the cell.
        """
        super().__init__(builder)
        self.set_record(cell_idx, XM_NODATA, record, period_rows)
        self._ix_area = ix_area

    @override
    def _column_values_from_dicts(self, row_or_record, feature_id: int):
        """Returns the list of column values (a row) given row_or_record and map_import_info.

        Args:
            row_or_record: Can be either a record, if reading the shapefile, or a row, if reading the CSV file.
            feature_id (int): ID of current feature object.

        Returns:
            (list): See description.
        """
        column_values = []
        for key in self._builder.map_import_info.keys():
            if key == 'COND':
                column_values.append(self._column_value(feature_id, key, row_or_record, self._ix_area))
            else:
                column_values.append(self._column_value(feature_id, key, row_or_record, 1.0))
        return column_values
