"""Base class for tests which use unittest.TestCase."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import unittest

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.misc.log_util import LogContext


class BaseTestCase(unittest.TestCase):
    """Base class for tests which use unittest.TestCase."""
    def __init__(self, method_name):
        """Initializer."""
        super().__init__(method_name)
        self._log_context = None

    def setUp(self):
        """Called before every test."""
        self._log_context = LogContext(self.id())
        self._log_context.__enter__()

    def tearDown(self):
        """Called after every test."""
        # from xms.mf6.misc import log_util
        # self.assertTrue(not log_util.errors_logged(self._log_context.logger), 'tearDown(): errors were logged')
        self._log_context.__exit__(None, None, None)

    def _logger_name(self) -> str:
        """Return the logger name."""
        if self._log_context and self._log_context.logger:
            return self._log_context.logger.name
        return ''
