"""Module for the simulation comonent."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['PtmSimComponent']

# 1. Standard Python modules
from pathlib import Path
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.component_bases.sim_component_base import SimComponentBase
from xms.gmi.data.generic_model import Section

# 4. Local modules
from xms.ptm.model.model import simulation_model


class PtmSimComponent(SimComponentBase):
    """Component for the PTM simulation."""
    def __init__(self, main_file: Optional[str | Path] = None):
        """
        Initialize the component class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)
        self._section_dialog_keyword_args = {'hide_checkboxes': True}

    def _get_global_parameter_section(self) -> Section:
        """Get the global parameter section."""
        return simulation_model()
