"""Module for Geometry and Boundary classes."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"
__all__ = ['Boundary', 'Geometry']

# 1. Standard Python modules
from dataclasses import dataclass, field
from typing import Sequence

# 2. Third party modules

# 3. Aquaveo modules
from xms.grid.ugrid import UGrid

# 4. Local modules


@dataclass
class Boundary:
    """
    Data class representing a boundary.

    Args:
        boundary_type: The boundary's type.
        nodes: IDs of nodes on the boundary.
    """
    boundary_type: int = 0
    nodes: Sequence[int] = field(default_factory=list)


@dataclass
class Geometry:
    """
    Class representing the content of a fort.14 geometry file.

    There are multiple formats of .fort.14 file. This one contains a full definition of a UGrid, plus boundaries. See
    Fort14Dataset for an alternative that contains a dataset without boundaries.

    Args:
        header: The file's header. Models generally ignore this, but it may be useful for identifying the file type.
        ugrid: The domain geometry.
        open_boundaries: Open boundaries to write into the file.
        closed_boundaries: Closed boundaries to write into the file.
    """
    header: str = ''
    ugrid: UGrid = None
    open_boundaries: Sequence[Boundary] = field(default_factory=list)
    closed_boundaries: Sequence[Boundary] = field(default_factory=list)
