"""BcComponent class."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.component_bases.coverage_component_base import CoverageComponentBase
from xms.gmi.data.generic_model import Section
from xms.guipy.data.target_type import TargetType

# 4. Local modules
from xms.rsm.data.bc_data_def import generic_model


class BcComponent(CoverageComponentBase):
    """A Dynamic Model Interface (DMI) component base class."""
    def _get_section(self, target: TargetType) -> Section:
        return generic_model().section_from_target_type(target)
