"""Cell monitor data."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel

# 4. Local modules
from xms.rsm.data import monitor_data_def as mdd


def generic_model():
    """Gets a generic model for the boundary conditions coverage.

    Returns:
        (xms.gmi.data.generic_model.GenericModel): the generic model class
    """
    gm = GenericModel()
    _pt_data_def(gm)
    return gm


def _pt_data_def(gm):
    """Create parameters for points in the GenericModel class.

    Args:
        gm (GenericModel): Generic model class
    """
    pp = gm.point_parameters
    outputs = [
        ('ponding', 'Ponding (<ponding>)'),
        ('wtdepth', 'Depth to water table (<wtdepth>)'),
        ('head', 'Head (<head>)'),
        ('head_iter', 'Head at each iteration (<head_iter>)'),
        ('recharge', 'Recharge volume (<recharge>)'),
        ('runoff', 'Runoff volume (<runoff>)'),
        ('wsupply', 'Water supply withdrawal volume (<wsupply>)'),
        ('rain', 'Depth of rainfall (<rain>)'),
        ('rainvol', 'Rainfall volume (<rainvol>)'),
        ('rchgvol', 'Recharge volume (<rchgvol>)'),
        ('watercontent', 'Depth of saturated water content (<watercontent>)'),
        ('initvol', 'Initial water content volume (<initvol>)'),
        ('wcvol', 'Saturated water content volumne (<wcvol>)'),
        ('topo', 'Land surface elevation (<topo>)'),
        ('inflow', 'Inflow volume from adjacent waterbodies (<inflow>)'),
        ('waterlevel', 'Elevation from "head - land surface" (<waterlevel>)'),
        ('sy', 'Specific yield (<sy>)'),
        ('transmissivity', 'Transmissivity (<transmissivity>)'),
    ]

    for name, label in outputs:
        gp = pp.add_group(group_name=name, label=label)
        mdd.add_output_to_group(gp)
