"""Class for writing mesh bcs to model input files."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os.path

# 2. Third party modules
import pandas as pd

# 3. Aquaveo modules

# 4. Local modules


class CsvWriter:
    """Writer class for the RSM control file."""
    def __init__(self):
        """Constructor."""
        self._csv_files = set()
        self._desired_filename = ''

    def set_desired_filename(self, desired_filename):
        """Set the desired filename.

        Args:
            desired_filename (str): The desired filename.
        """
        self._desired_filename = desired_filename

    def write_csv_file(self, xy):
        """Write the csv file.

        Args:
            xy (tuple(sequence, sequence)): The data to write to the csv file.

        Returns:
            dict: xml attributes.
        """
        base_name = os.path.splitext(self._desired_filename)[0]
        cnt = 1
        while base_name in self._csv_files:
            base_name = f'{base_name}_{cnt}'
            cnt += 1
        self._csv_files.add(base_name)
        out_file = f'{base_name}.csv'
        with open(out_file, 'w') as f:
            f.write('Date,Time,Values\n')
            times = xy[0]
            vals = xy[1]
            for i in range(len(times)):
                dt = pd.to_datetime(times[i])
                date = dt.strftime('%d %b %Y')
                time = dt.strftime('%H:%M:%S')
                v = f'{vals[i]}'
                f.write(f'{date},{time},{v}\n')
        atts = {
            'file': out_file,
            'label': 'Values',
            'timeStamp': 'date',
        }
        return atts
