"""Module for the BcTidesFile class."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass
from typing import Sequence

# 2. Third party modules
import xarray as xr

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class BcTidesFile:
    """
    Class representing a bctides.in file.

    Args:
        cutoff_depth: The cutoff depth field in the file.
        open_boundaries: A sequence of boundaries. Each boundary is a sequence of node IDs comprising the boundary.

            The writer uses this to look up tidal information for a boundary. The reader has no idea how to create it,
            and so leaves it uninitialized.
        values: Extracted from a `GenericModel`. Parallel to `start_indexes`.
        forcing_frequencies: Dataset with tidal forcing frequencies. Has columns 'name' (str), 'frequency' (float),
            'factor' (float), and 'argument' (float).
        elevation: Dataset with elevation forcing data.
        velocity: Dataset with velocity forcing data.
    """
    cutoff_depth: float = 0.0
    open_boundaries: Sequence[Sequence[int]] = None
    values: Sequence[str] = None
    forcing_frequencies: xr.Dataset = None
    elevation: xr.Dataset = None
    velocity: xr.Dataset = None
