"""xms_zip.py."""

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"

# 1. Standard python modules
from pathlib import Path
import shutil
import sys

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def zip_dir(directory: str, zip_file_path: str) -> bool:
    """Zips a directory.

    Args:
        directory (str): The directory to zip.
        zip_file_path (str): Name of the .zip file to create.

    Returns:
        (bool) True if successful.
    """
    try:
        base_name = str(Path(zip_file_path).with_suffix(''))  # "name of file to create, including path, minus extension
        rv = shutil.make_archive(base_name, 'zip', directory)
    except Exception as exc:
        print(str(exc))
        return False
    return rv != ''


def main(argv) -> int:
    """Main function.

    Args:
        argv (list[str]): Command line arguments

    Returns:
        (int) 0 on success, non-zero on failure.
    """
    rv = 0
    if argv and len(argv) == 4 and argv[0] == '-o' and argv[1] == 'zip_dir':
        rv = zip_dir(argv[2], argv[3])
    else:
        usage = (
            'usage: xms_zip.py -o OPTION [files]\n'
            '\n'
            'OPTION = zip_dir (for now, "zip_dir" is the only one, but we might add more options in the future).\n'
            '\n'
            'example:\n'
            'xmszip -o zip_dir C:\\temp\\dir file.zip        (Zips C:\\temp\\dir folder and creates file.zip)\n'
        )
        print(usage)

    return 0 if rv else 1


if __name__ == '__main__':  # pragma no cover - can't run this from the tests and it must be here
    # from xms.guipy import debug_pause
    # debug_pause()
    main(sys.argv[1:])
