"""Entry point to run PEST."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import argparse

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
import xms.srh.model.srh_pest_model


def main():
    """The main routine."""
    arguments = argparse.ArgumentParser(description="Component.")
    arguments.add_argument(dest='script', type=str, help='script to run')
    arguments.add_argument('-j', '--json-file', help='Path to srh_pest.json', required=True, default='')
    parsed_args = arguments.parse_args()
    if parsed_args.script == 'pest':
        xms.srh.model.srh_pest_model.run_model(parsed_args.json_file)


if __name__ == "__main__":
    main()
