"""SrhCoverageComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.srh.components.srh_component import SrhComponent

MONITOR_PT_DISPLAY_OPTIONS_JSON = 'monitor_point_display_options.json'
MONITOR_PT_DISPLAY_ID_FILE = 'measured_value.display_ids'


class SrhCoverageComponent(SrhComponent):
    """A hidden Dynamic Model Interface (DMI) component for the SRH-2D model simulation."""
    def __init__(self, main_file):
        """Initializes the base component class.

        Args:
            main_file: The main file associated with this component.

        """
        super().__init__(main_file)

    def ensure_cov_uuid(self, query):
        """Ensure the cov uuid is set.

        Args:
            query (:obj:`xms.api.dmi.Query`): Object for communicating with XMS
        """
        if self.cov_uuid != '':
            return [], []
        self.cov_uuid = query.parent_item_uuid()
        if not self.cov_uuid:
            return [('ERROR', 'Could not get SRH-2D coverage UUID.')], []
        self.data.info.attrs['cov_uuid'] = self.cov_uuid
        self.data.commit()
        return [], []
