"""ObstructionData class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.srh.data.par.obstruction_param import ObstructionParam
from xms.srh.data.srh_coverage_data import SrhCoverageData


class ObstructionData(SrhCoverageData):
    """Class for storing the SRH Material properties (Manning's N and sediment)."""
    def __init__(self, filename):
        """Constructor.

        Args:
            filename (:obj:`str`): file name
        """
        super().__init__(filename, 'SRH_OBSTRUCTION_DATA', 'obstruction_data')

    @property
    def obstruction_data(self):
        """Get the obstruction dataset.

        Returns:
            (:obj:`xarray.Dataset`): The obstruction_data list dataset

        """
        return self.data

    @obstruction_data.setter
    def obstruction_data(self, dset):
        """Setter for the _obstruction_data dataset."""
        self.data = dset

    def obstruction_data_param_from_id(self, data_id):
        """Gets a record from an id. If the id is not in the obstruction_data then returns None.

        Args:
            data_id (:obj:`int`): component id

        Returns:
            (:obj:`ObstructionParam`): The record from the bc dataframe as a ObstructionParam class
        """
        obs = ObstructionParam()
        return self.param_from_id(data_id, obs)

    def append_obstruction_data_with_id(self, obstruction_data, data_id):
        """Sets a record with an id. If the id is < 1 then do nothing.

        Args:
            obstruction_data (:obj:`ObstructionParam`): instance of obstruction data
            data_id (:obj:`int`): component id

        """
        self.append_param_data_with_id(obstruction_data, data_id)
