"""BcDataWeir class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules
from xms.srh.data.par.bc_data_weir_type import BcDataWeirType


class BcDataWeir(param.Parameterized):
    """Bc type weir data."""
    units = param.ObjectSelector(
        default='Feet',
        objects=['Feet', 'Meters'],
        doc='',
        precedence=1,
    )
    crest_elevation = param.Number(
        default=0.0,
        doc='',
        precedence=2,
    )
    length = param.Number(
        default=0.0,
        doc='',
        precedence=3,
    )
    type = param.ClassSelector(
        label='',
        class_=BcDataWeirType,
        doc='',
        precedence=4,
    )
    total_head = param.Boolean(
        label='Use total head (velocity and water surface)',
        default=False,
        doc='',
        precedence=5,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.type = BcDataWeirType()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=[],
            depends={},
        )
