"""BcDataArcs class."""

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules

# 4. Local modules
from xms.srh.data.model_control import ModelControl


class DataIoStringParam(param.Parameterized):
    """Data for a BCDATA bc type."""
    file_type = param.String(
        doc='file type identifier for file_io',
        precedence=-2,
    )
    text = param.String(
        default='',
        doc='text data',
        precedence=1,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        tmp = ModelControl()
        self.file_type = tmp.file_type
