"""The param data class for EWN Feature coverage polygons."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules

# 4. Local modules


class SummaryReportDialogData(param.Parameterized):
    """param class to represent an EWN Feature coverage polygon."""
    river = param.String(
        label='River',
        default='',
        doc='The river being modeled.',
        precedence=1,
    )
    project_purpose = param.String(
        label='Project purpose/focus',
        default='',
        doc='Purpose of the project',
        precedence=2,
    )
    model_developer_name = param.String(
        label='Model developer name',
        default='',
        doc='Name of the model developer',
        precedence=3,
    )
    terrain_source = param.String(
        label='Source of terrain data',
        default='',
        doc='Source of terrain data',
        precedence=4,
    )
    bathymetry_source = param.String(
        label='Source of bathymetry data',
        default='',
        doc='Source of bathymetry data',
        precedence=5,
    )
    additional_survey_source = param.String(
        label='Additional data sources',
        default='',
        doc='Additional data sources',
        precedence=6,
    )

    def __init__(self):
        """Initializes the base parameter class."""
        super().__init__()  # pragma: no cover
