"""I/O utility methods."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def is_float(value):
    """Returns true if the string value is a float.

    See https://stackoverflow.com/questions/736043

    Args:
        value : The object to perform type checking on

    Returns:
        (:obj:`bool`): See description.
    """
    try:
        float(value)
        return True
    except ValueError:
        return False


def read_xys(filename):
    """Reads the xys file.

    Args:
        filename (:obj:`str`): Filepath of xys curve file.

    Returns:
        (:obj:`bool, list, list`): True if a rating curve, list of x values, list of y values
    """
    with open(filename, 'r') as file:
        lines = file.read().splitlines()
        x = []
        y = []
        for line in lines[1:]:
            words = line.split()
            if len(words) < 2:
                continue
            x.append(float(words[0]))
            y.append(float(words[1]))
        return 'Rating_Curve' in lines[0], x, y


def is_valid_uuid(val):
    """Returns True if val is a uuid.

    Args:
        val (:obj:`str`): A string that may or may not be a valid uuid.

    Returns:
        (:obj:`bool`): See description.
    """
    try:
        uuid.UUID(str(val))
        return True
    except ValueError:
        return False
