"""Qt edit model for the sediment attributes data model."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import QSortFilterProxyModel, Qt

# 3. Aquaveo modules

# 4. Local modules
from xms.srh.data.material_data import MaterialData


class SedAttDisableEditModel(QSortFilterProxyModel):
    """A model to set enabled/disabled states."""
    def __init__(self, parent=None):
        """Initializes the filter model.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
        """
        super().__init__(parent)

    def flags(self, index):
        """Set flags for an item in the model.

        Args:
            index (:obj:`QModelIndex`): The item's model index

        Returns:
            (:obj:`Qt.ItemFlags`): Updated flags for the item
        """
        ret_flags = super().flags(index)
        col = index.column()
        if col == MaterialData.COL_PROP_GRADATION_CURVE:  # Disable editing of the unassigned material name
            ret_flags = ret_flags & (~Qt.ItemIsEditable)
        else:
            ret_flags |= Qt.ItemIsEnabled
        return ret_flags
