"""Magic strings used in the DMI database by old SRH-2D SMS projects."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

BC_INLET_Q = 'Inlet-Q (subcritical inflow)'
BC_EXIT_H = 'Exit-H (subcritical outflow)'
BC_EXIT_Q = 'Exit-Q (known-Q outflow)'
BC_INLET_SC = 'Inlet-SC (supercritical inflow)'
BC_EXIT_EX = 'Exit-EX (supercritical outflow)'
BC_WALL = 'Wall (no-slip boundary)'
BC_SYMMETRY = 'Symmetry (slip boundary)'
BC_INTERNAL_SINK = 'Internal sink'
STRUCT_SET_HY8 = 'Culvert HY-8'
STRUCT_SET_CULVERT = 'Culvert'
STRUCT_SET_WEIR = 'Weir'
STRUCT_SET_PRESSURE = 'Pressure'
STRUCT_SET_GATE = 'Gate'
STRUCT_SET_LINK = 'Link'

STRUCT_SET_WIDGETS = {
    STRUCT_SET_HY8: 'setHY8Culvert',
    STRUCT_SET_CULVERT: 'setCulvert',
    STRUCT_SET_WEIR: 'setWeir',
    STRUCT_SET_PRESSURE: 'setPressure',
    STRUCT_SET_GATE: 'setGate',
    STRUCT_SET_LINK: 'setLink',
}

BC_TYPE_DB_TO_COMP = {  # Most match, but capitalization differs for a few.
    BC_INLET_Q: BC_INLET_Q,
    BC_EXIT_H: BC_EXIT_H,
    BC_EXIT_Q: BC_EXIT_Q,
    BC_INLET_SC: BC_INLET_SC,
    BC_EXIT_EX: BC_EXIT_EX,
    'Wall (No-slip boundary)': BC_WALL,
    'Symmetry (Slip boundary)': BC_SYMMETRY,
    BC_INTERNAL_SINK: BC_INTERNAL_SINK,
    STRUCT_SET_HY8: STRUCT_SET_HY8,
    STRUCT_SET_CULVERT: STRUCT_SET_CULVERT,
    STRUCT_SET_WEIR: STRUCT_SET_WEIR,
    STRUCT_SET_PRESSURE: STRUCT_SET_PRESSURE,
    STRUCT_SET_GATE: STRUCT_SET_GATE,
    STRUCT_SET_LINK: STRUCT_SET_LINK,
}

CURVE_OPTION_DB_TO_COMP = {  # We don't like to be consistent with capitalization on these.
    'Rating curve': 'Rating curve',
    'Rating Curve': 'Rating curve',
    'Time Series': 'Time series',
    'Constant': 'Constant',
    'Weir': 'Weir',
}
