"""The executable script used by SMS for running the final PEST process for SRH-2D PEST models."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os
import sys

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.srh.components.parameters.parameters_manager import ParametersManager


def run_pest_final_run(hydro_file, main_file):
    """Call PEST via command line scripts for an SRH-2D PEST model after running the main SRH-2D executable.

    Args:
        hydro_file (:obj:`str`): Path to the run's *.srhhydro file
        main_file (:obj:`str`): Path to the run's simulation component main file
    """
    parameters = []
    if hydro_file:
        hydro_file = hydro_file.strip()
        tpl_file = f'{hydro_file}.tpl'
        par_file = f'{os.path.splitext(hydro_file)[0]}.par'
        with open(tpl_file, 'r') as f:
            hydro_lines = f.readlines()
        with open(par_file, 'r') as f:
            par_lines = f.readlines()
            if par_lines:
                for line in par_lines:
                    data = line.split()
                    if len(data) == 4:
                        parameters.append(data)
        # print(f'Optimized Parameters: {parameters}')
        # print(f'SRH-HYDRO File: {hydro_lines}')
        if len(parameters) and hydro_lines:
            with open(hydro_file, 'w') as f:
                for line in hydro_lines:
                    if 'ptf $' not in line:
                        line_write = line
                        for p in parameters:
                            search_str = f'${p[0]}$'
                            if search_str in line:
                                line_write = line.replace(search_str, f'{float(p[1])}')
                                break
                        f.write(line_write)
    if len(parameters) and main_file:
        main_file = main_file.strip()
        # print(f'Main file: {main_file}')
        param_data = ParametersManager.read_parameter_file(main_file)
        # print(f'Input Param Data: {param_data}')
        params = param_data['params']
        for i, _id in enumerate(params['id']):
            for p in parameters:
                if p[0] == _id:
                    opt_value = float(p[1])
                    print(f"Changed optimized value for {_id} from {params['Optimized Value'][i]} to {opt_value}")
                    params['Optimized Value'][i] = opt_value
        # print(f'Output Param Data: {param_data}')
        ParametersManager.write_parameter_file(main_file, param_data)
        sys.stdout.flush()
