"""Entry point for reading STWAVE solution files."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.components.display import windows_gui as win_gui
from xms.guipy.dialogs import xms_parent_dlg as xms_dlg
from xms.guipy.dialogs.xms_parent_dlg import ensure_qapplication_exists

# 4. Local modules
from xms.stwave.simulation_runner.simulation_run import SimulationRun

if __name__ == '__main__':
    ensure_qapplication_exists()
    # Parse parent HWNDs and icon path from commandline arguments.
    parent_hwnd, main_hwnd, _ = xms_dlg.parse_parent_window_command_args()
    win_cont = xms_dlg.get_parent_window_container(parent_hwnd)
    # Create the timer that keeps our Python dialog in the foreground of XMS.
    _ = win_gui.create_and_connect_raise_timer(main_hwnd, win_cont)  # Keep the timer in scope

    try:
        solution_reader = SimulationRun()
        solution_reader.setup_query()
        solution_reader.single_solution_file = solution_reader.query.read_file
        solution_reader.read_solution(query=solution_reader.query, params=None, win_cont=win_cont)
        if solution_reader.read_data:
            solution_reader.query.send()
    except Exception as ex:
        import traceback
        f = open("sms_stwave_solution_import.log", "w")
        traceback.print_exception(type(ex), ex, ex.__traceback__, file=f)
        f.close()
        raise ex
